

********************************************************************************************************************************************************************
********************************************************************************************************************************************************************
*** Replication do-file for "The Power of Religion"
*** by Jeanet Sinding Bentzen and Gunes Gokmen
*** June, 2022
********************************************************************************************************************************************************************
********************************************************************************************************************************************************************


**********************************************************************************
**********************************************************************************
*** Table A.11: Regressions of individual laws on irrigation potential and high gods
**********************************************************************************

*** Coefficients on the effect of irrigation potential on 51 religious laws (columns 1 and 2)
clear
clear matrix
clear mata
set maxvar 32000
use all_laws_irrigation, clear


tempname A11_coeffs
postfile `A11_coeffs' str12 mean_num nr mean_df_short mean_coeff_short mean_se_short using A11_coeffs.dta, replace
foreach j in  01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 ///
20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 ///
44 45 46 47 48 49 50 51  {
reghdfe mean_`j' irri_impact5, a(continent)
post `A11_coeffs' (`"`j'_mean"') (`j') (e(df_r)) (`=_b[irri_impact5]') (`=_se[irri_impact5]') 
}

postclose `A11_coeffs' 
use A11_coeffs
merge 1:1 nr using labels
drop _merge
gen p_val  = (2 * ttail( mean_df_short , abs( mean_coeff_short / mean_se_short )))
replace p_val=round(p_val, 0.001)
gsort -mean_coeff_short
gen laws_order = _n
label var laws_order "Laws ranked according to size of parameter estimate"
save A11_coeffs, replace



*** Coefficients on the effect of high gods on 51 religious laws (columns 3 and 4)
clear
clear matrix
clear mata
set maxvar 32000
use all_laws_god, clear

tempname figure4_coeffs
postfile `figure4_coeffs' str12 mean_num nr mean_df_short mean_coeff_short mean_se_short using figure4_coeffs.dta, replace
foreach j in  01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 ///
20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 ///
44 45 46 47 48 49 50 51  {
reghdfe mean_`j' god, a(continent)
post `figure4_coeffs' (`"`j'_mean"') (`j') (e(df_r)) (`=_b[god]') (`=_se[god]') 
}

postclose `figure4_coeffs' 
use figure4_coeffs
merge 1:1 nr using labels
drop _merge
gen p_val  = (2 * ttail( mean_df_short , abs( mean_coeff_short / mean_se_short )))
replace p_val=round(p_val, 0.001)
gen lowerbound_90 = mean_coeff_short - 1.645*mean_se_short
gen upperbound_90 = mean_coeff_short + 1.645*mean_se_short
gsort -mean_coeff_short
gen laws_order = _n
label var laws_order "Laws ranked according to size of parameter estimate"
save figure4_coeffs, replace 

********************************************************************************************************************************************************************